/*
 * Decompiled with CFR 0.152.
 */
package GameState;

import Entity.MenuOption;
import Entity.Mouse;
import GameState.GameState;
import GameState.GameStateManager;
import Handlers.Content;
import Handlers.Keys;
import Handlers.Options;
import java.awt.Color;
import java.awt.Desktop;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.io.IOException;
import java.net.URI;

public class CreditsState
extends GameState {
    private Font customFont;
    private Font font;
    private MenuOption mo;
    private Mouse mouse;
    private int currentChoice = 0;
    private String[] options = new String[]{"Work4Games.no-ip.org", "Back"};

    public CreditsState(GameStateManager gsm) {
        this.gsm = gsm;
        try {
            this.customFont = Font.createFont(0, this.getClass().getResourceAsStream("/Fonts/ka1.ttf")).deriveFont(52.0f);
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            ge.registerFont(Font.createFont(0, this.getClass().getResourceAsStream("/Fonts/ka1.ttf")));
            ge.registerFont(Font.createFont(0, this.getClass().getResourceAsStream("/Fonts/ka1.ttf")));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (FontFormatException e) {
            e.printStackTrace();
        }
        this.font = new Font("Arial", 0, 22);
        this.mo = new MenuOption(this.options, gsm.regFont, 400, 270, 0, 60);
        this.mouse = new Mouse();
        this.currentChoice = 1;
    }

    @Override
    public void init() {
    }

    @Override
    public void update() {
        this.handleInput();
        this.mo.update(this.mouse);
        this.mouse.update();
    }

    @Override
    public void draw(Graphics2D g) {
        g.drawImage((Image)Content.MenuBG, 0, 0, null);
        g.setFont(this.customFont);
        g.setColor(Color.WHITE);
        this.gsm.drawCenteredString("Work4Games", 800, 250, g);
        g.setFont(this.font);
        this.gsm.drawCenteredString("Created by Darryl Day", 800, 360, g);
        this.gsm.drawCenteredString("Visit my website to stay up to date on my lastest games and releases:", 800, 440, g);
        this.gsm.drawCenteredString("", 800, 480, g);
        g.setFont(this.gsm.regFont);
        if (Options.getOption(5)) {
            this.mo.draw(g);
            this.mouse.draw(g);
        } else {
            int i = 0;
            while (i < this.options.length) {
                if (i == this.currentChoice) {
                    g.setColor(Color.YELLOW);
                } else {
                    g.setColor(Color.WHITE);
                }
                this.gsm.drawCenteredString(this.options[i], 800, 540 + i * 120, g);
                ++i;
            }
        }
    }

    private void select(int currentChoice) {
        if (currentChoice == 0) {
            try {
                URI uri = new URI("http://work4games.no-ip.org");
                Desktop dt = Desktop.getDesktop();
                dt.browse(uri);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (currentChoice == 1) {
            this.gsm.setState(0);
        }
    }

    @Override
    public void handleInput() {
        if (Keys.isKeyPressed(Keys.ESCAPE)) {
            this.gsm.setState(0);
        }
        if (Options.getOption(5)) {
            if (Keys.isMousePressed(Keys.LEFTCLICK)) {
                this.select(this.mo.getChoice());
            }
        } else {
            if (Keys.isKeyPressed(Keys.ENTER)) {
                this.select(this.currentChoice);
            }
            if (Keys.isKeyPressed(Keys.UP)) {
                this.currentChoice = this.currentChoice > 0 ? --this.currentChoice : this.options.length - 1;
            }
            if (Keys.isKeyPressed(Keys.DOWN)) {
                this.currentChoice = this.currentChoice < this.options.length - 1 ? ++this.currentChoice : 0;
            }
        }
    }
}

